###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_detect_win.nasl 388 2008-10-30 11:22:09Z oct $
#
# Google Chrome Version Detection (Windows)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800120);
  script_version("Revision: 1.0 ");
  script_name("Google Chrome Version Detection (Windows)");
  desc = "
  Overview: This script finds the Google Chrome installed version on Windows
  and save the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set Version of Google Chrome in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Get the Google Chrome Version from HKU (HKEY_USER).
function hku_registry_get_sz(key)
{
  if(!port){
    port = 139;
  }

  if(!get_port_state(port)){
    exit(0);
  }

  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  r = smb_session_request(soc:soc, remote:name);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  prot = smb_neg_prot(soc:soc);
  if(!prot)
  {
    close(soc);
    exit(0);
  }

  r = smb_session_setup(soc:soc, login:login, password:pass,
                        domain:domain, prot:prot);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);
  r = smb_tconx(soc:soc, name:name, uid:uid, share:"IPC$");

  tid = tconx_extract_tid(reply:r);
  if(!tid)
  {
    close(soc);
    exit(0);
  }

  r = smbntcreatex(soc:soc, uid:uid, tid:tid, name:"\winreg");
  if(!r)
  {
    close(soc);
    exit(0);
  }

  pipe = smbntcreatex_extract_pipe(reply:r);
  if(!pipe)
  {
    close(soc);
    exit(0);
  }

  r = pipe_accessible_registry(soc:soc, uid:uid, tid:tid, pipe:pipe);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  r = registry_open_hku(soc:soc, uid:uid, tid:tid, pipe:pipe);
  if(!r)
  {
    close(soc);
    exit(0);
  }

  item = "Version";
  key = key + "\Software\Microsoft\Windows\CurrentVersion\Uninstall\Google Chrome";

  r2 = registry_get_key(soc:soc, uid:uid, tid:tid, pipe:pipe, key:key, reply:r);
  if(r2)
  {
    r3 = registry_get_item_sz(soc:soc, uid:uid, tid:tid, pipe:pipe, item:item, reply:r2);
    registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:r2);
    registry_close(soc:soc, uid:uid, tid:tid, pipe:pipe, reply:r);
    if(r3){
      value = registry_decode_sz(data:r3);
    }
    close(soc);
    return value;
  }
  close(soc);
  return(FALSE);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Group Policy";
enumKeys = registry_enum_keys(key:key);

foreach key (enumKeys)
{
  chromeVer = hku_registry_get_sz(key:key);
  if(chromeVer)
  {
    set_kb_item(name:"GoogleChrome/Win/Ver", value:chromeVer);
    exit(0);
  }
}
