###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_mult_vuln_jan10.nasl 2010-01-16 14:20:26Z jan $
#
# Google Chrome Multiple Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800431);
  script_version("$Revision: 6460 $: 1.0");
  script_cve_id("CVE-2010-0315");
  script_name("Google Chrome Multiple Vulnerabilities");
  desc = "
  Overview: This host is installed with Google Chrome Web Browser and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  The flaws exists due to error in 'HREF' attribute of a stylesheet 'LINK'
  element, when reading the 'document.styleSheets[0].href' property value.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code, bypass
  security restrictions, sensitive information disclosure, and can cause other
  attacks.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version 4.0.288.1 and prior on Windows.

  Fix:
  No solution or patch is available as on as on 15th January, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.google.com/chrome

  References:
  http://en.securitylab.ru/nvd/389797.php
  http://nomoreroot.blogspot.com/2010/01/little-bug-in-safari-and-google-chrome.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

gcVer = get_kb_item("GoogleChrome/Win/Ver");
if(!gcVer){
  exit(0);
}

# Check for Apple Safari Version 4.0.288.1 and prior
if(version_is_less_equal(version:gcVer, test_version:"4.0.288.1")){
  security_hole(0);
}
