##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_sketchup_detect_win.nasl 6861 2010-01-19 14:20:24Z jan $
#
#  Google SketchUp Version Detection (Windows)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800434);
  script_version("$Revision: 6460 $: 1.0");
  script_name("Google SketchUp Version Detection (Windows)");
  desc = "
  Overview: This script detects the installed version of Google SketchUp and
  saves the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the KB for the version of Google SketchUp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Google")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  gsName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Google SketchUp" >< gsName)
  {
    path = registry_get_sz(key:key + item , item:"InstallLocation");
    exePath = path + "\SketchUp.exe";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);

    gsVer = GetVer(file:file, share:share);
    if(gsVer != NULL)
    {
      set_kb_item(name:"Google/SketchUp/Win/Ver", value:gsVer);
      exit(0);
    }
  }
}
