###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for libDtSvc HPSBUX00308
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835142);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00308");
  script_cve_id("");
  script_name( "HP-UX Update for libDtSvc HPSBUX00308");
  desc = "

  Vulnerability Insight:
  A locally exploitable buffer overflow has beenidentified in libDtSvc which 
  can be used to gain increased privilege. 

  Impact:
  Local increase in privilege.

  Affected Software/OS:
  libDtSvc on
  HP-UX B.11.00, B.11.04, B.11.11, and B.11.22. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00908671-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libDtSvc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_28675'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TT", patch_list:['PHSS_28675'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_28675'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_28675'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_28675'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-DTTERM", patch_list:['PHSS_28675'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-FONTS", patch_list:['PHSS_28675'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_28682'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_28682'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_28682'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_30167'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TT", patch_list:['PHSS_30167'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_30167'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-RUN", patch_list:['PHSS_30167'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_30167'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-DTTERM", patch_list:['PHSS_30167'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-FONTS", patch_list:['PHSS_30167'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TCH-B-MSG", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ITA-I-MSG", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-ENG-A-MSG", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-DTTERM", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SCH-H-MSG", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SWE-I-MSG", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-MIN", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-TT", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CDE.CDE-SHLIBS", patch_list:['PHSS_28676'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}