###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Process Resource Manager (PRM) HPSBUX01065
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835072);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "01065");
  script_cve_id("");
  script_name( "HP-UX Update for Process Resource Manager (PRM) HPSBUX01065");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identifiedwith HP-UX Process 
  Resource manager (PRM), HP-UX Workload Manager (WLM) uses PRM to control 
  resources, so the vulnerability also exists for this software. This 
  vulnerability could be exploited by a local user to cause data file 
  corruption. 

  Impact:
  Local data file corruption.

  Affected Software/OS:
  Process Resource Manager (PRM) on
  HP-UX B.11.00, B.11.11, B.11.23 running Process Resource Manager (PRM) 
  C.02.01 (.01) and prior versions and Workload Manager (WLM) A.02.01 and 
  prior versions. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00915992-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Process Resource Manager (PRM)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"Proc-Resrc-Mgr.PRM-RUN", revision:"C.02.02", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PRM-Sw-Lib.PRM-LIB", revision:"C.02.02", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"WLM-Monitor", revision:"A.02.02", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Workload-Mgr", revision:"A.02.02", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Proc-Resrc-Mgr.PRM-RUN", revision:"C.02.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PRM-Sw-Lib.PRM-LIB", revision:"C.02.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"WLM-Monitor", revision:"A.02.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Workload-Mgr", revision:"A.02.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Proc-Resrc-Mgr.PRM-RUN", revision:"C.02.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"PRM-Sw-Lib.PRM-LIB", revision:"C.02.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"WLM-Monitor", revision:"A.02.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"Workload-Mgr", revision:"A.02.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}