###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache Remote Execution of Arbitrary Code HPSBUX02186
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835119);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02186");
  script_cve_id("CVE-2006-2940", "CVE-2006-2937", "CVE-2006-3738", "CVE-2006-4343", "CVE-2006-4339", "CVE-2005-2969");
  script_name( "HP-UX Update for Apache Remote Execution of Arbitrary Code HPSBUX02186");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with Apache running 
  on HP-UX. These vulnerabilities could be exploited remotely to allow 
  execution of arbitrary code, Denial of Service (DoS), or unauthorized 
  access. 

  Impact:
  Remote execution of arbitrary code
  Denial of Service (DoS)
  and unauthorized access.

  Affected Software/OS:
  Apache Remote Execution of Arbitrary Code on
  HP-UX B.11.11, B.11.23, and B.11.31 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00849540-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache Remote Execution of Arbitrary Code");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"A.2.0.58.01", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.58.01", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"A.2.0.58.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.58.01", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}