###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache Web Server Suite HPSBUX02401
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835190);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02401");
  script_cve_id("CVE-2007-6420", "CVE-2008-1232", "CVE-2008-1947", "CVE-2008-2364", "CVE-2008-2370", "CVE-2008-2938", "CVE-2008-2939", "CVE-2008-3658");
  script_name( "HP-UX Update for Apache Web Server Suite HPSBUX02401");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with HP-UX running 
  Apache-based Web Server or Tomcat-based Servelet Engine. The vulnerabilities 
  could be exploited remotely to cause a Denial of Service (DoS), cross-site 
  scripting (XSS), execution of arbitrary code, or cross-site request forgery 
  (CSRF). Apache-based Web Server and Tomcat-based Servelet Engine are 
  contained in the Apache Web Server Suite. 

  Impact:
  Remote Denial of Service (DoS)
  cross-site scripting (XSS)
  execution of arbitrary code
  cross-site request forgery (CSRF)

  Affected Software/OS:
  Apache Web Server Suite on
  HP-UX B.11.23 and B.11.31 running Apache-based Web Server v2.2.8.01.01 or 
  v2.0.59.07.02 or earlier or Tomcat-based Servelet Engine v5.5.27.01 or 
  earlier HP-UX B.11.11 running Apache-based Web Server v2.0.59.07.02 or 
  earlier or Tomcat-based Servelet Engine v5.5.27.01 or earlier 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01650939-4

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache Web Server Suite");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.APACHE", revision:"B.2.2.8.01.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APACHE.APACHE2", revision:"B.2.2.8.01.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22TOMCAT.TOMCAT", revision:"B.2.2.8.01.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE", revision:"B.2.0.59.07.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE2", revision:"B.2.0.59.07.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"B.2.0.59.07.03", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.APACHE", revision:"B.2.2.8.01.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22APCH32.APACHE2", revision:"B.2.2.8.01.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxws22TOMCAT.TOMCAT", revision:"B.2.2.8.01.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE", revision:"B.2.0.59.07.03", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPCH32.APACHE2", revision:"B.2.0.59.07.03", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"B.2.0.59.07.03", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE", revision:"B.2.0.59.07.03", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE.APACHE2", revision:"B.2.0.59.07.03", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsTOMCAT.TOMCAT", revision:"B.2.0.59.07.03", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
