###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for XNTP HPSBUX02437
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835204);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02437");
  script_cve_id("CVE-2009-0159", "CVE-2009-1252");
  script_name("HP-UX Update for XNTP HPSBUX02437");
  desc = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with HP-UX running 
  XNTP. The vulnerabilities could be exploited remotely to execute arbitrary 
  code. 

  Impact:
  Remote execution of arbitrary code

  Affected Software/OS:
  XNTP on
  HP-UX B.11.11, B.11.23, B.11.31 running XNTP version 3.5 prior to patch 
  B11.11 PHNE_39871, B11.23 PHNE_39872 or B.11.31 PHNE_39873. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01763606-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of XNTP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"NTP.NTP-RUN", patch_list:['PHNE_39873'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS2-BOOT", patch_list:['PHNE_39872'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS-BOOT", patch_list:['PHNE_39871'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}