###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Role-Based Access Control (RBAC) HPSBUX02457
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835214);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02457");
  script_cve_id("CVE-2009-2682");
  script_name("HP-UX Update for Role-Based Access Control (RBAC) HPSBUX02457");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  Role-Based Access Control (RBAC). The vulnerability could be exploited 
  locally to gain unauthorized access. 

  Impact:
  Local unauthorized access

  Affected Software/OS:
  Role-Based Access Control (RBAC) on
  HP-UX B.11.23 and HP-UX B.11.31 running RBAC 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01866178-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Role-Based Access Control (RBAC)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"RBAC.RBAC-CONF", patch_list:['PHCO_40131'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"RBAC.RBAC-RUN", patch_list:['PHCO_40131'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"RBAC.RBAC-CONF", revision:"B.11.23.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"RBAC.RBAC-RUN", revision:"B.11.23.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"RBAC.RBAC-WEB", revision:"B.11.23.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}