###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for HP CIFS Server (Samba) HPSBUX02479
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835206);
  script_version("$Revision: 6682 $: 1.0");
  script_xref(name: "HPSBUX", value: "02479");
  script_cve_id("CVE-2009-2813");
  script_name("HP-UX Update for HP CIFS Server (Samba) HPSBUX02479");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running HP
  CIFS Server (Samba). The vulnerability could be exploited to gain remote
  unauthorized access.

  Impact:
  Remote unauthorized access

  Affected Software/OS:
  HP CIFS Server (Samba) on
  HP CIFS Server vA.02.03.04 and vA.02.04 running on HP-UX B.11.11, B.11.23,
  or B.11.31.

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01940841

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of HP CIFS Server (Samba)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");
if(release == NULL){
  exit(0);
}

pkgs_rev = get_kb_item("ssh/login/hp_pkgrev");
ver = eregmatch(pattern:"CIFS-Server.CIFS-ADMIN[	 ]+(A.02.0[34])",string:pkgs_rev);

if(ver == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{
  if (ver[1] == "A.02.04")
  {
    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.04.01", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.04.01", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.04.01", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-MAN", revision:"A.02.04.01", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.04.01", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.04.01", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }
  }

  if (ver[1] == "A.02.03")
  {
    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.03.05", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.03.05", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.03.05", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.03.05", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.03.05", rls:"HPUX11.31"))
    {
      security_hole(0);
      exit(0);
    }
  }

  if(ishpuxpkgvuln(pkg:"CIFS-CFSM.CFSM-KRN", revision:"A.02.03.05", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-CFSM.CFSM-RUN", revision:"A.02.03.05", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{
  if (ver[1] == "A.02.04")
  {
    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.04.01", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.04.01", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.04.01", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-MAN", revision:"A.02.04.01", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.04.01", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.04.01", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }
  }

  if (ver[1] == "A.02.03")
  {
    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.03.05", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.03.05", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.03.05", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.03.05", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.03.05", rls:"HPUX11.23"))
    {
      security_hole(0);
      exit(0);
    }
  }

  exit(0);
}


if(release == "HPUX11.11")
{
  if (ver[1] == "A.02.04")
  {
    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.04.01", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.04.01", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.04.01", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-MAN", revision:"A.02.04.01", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.04.01", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.04.01", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }
  }

  if (ver[1] == "A.02.03")
  {
    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.03.05", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.03.05", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.03.05", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.03.05", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }

    if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.03.05", rls:"HPUX11.11"))
    {
      security_hole(0);
      exit(0);
    }
  }
  exit(0);
}
