###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ibm_db2mc_detect.nasl 4412 2009-09-04 11:25:36Z sep $
#
# DB2 Monitoring Console Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c)2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800690);
  script_version("Revision: 1.0");
  script_name("DB2 Monitoring Console Version Detection");
  desc = "
  Overview: This script finds the installed DB2 Monitoring Console version
  and saves the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of DB2 Monitoring Console in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

dmcPort = get_http_port(default:80);
if(!dmcPort){
  dmcPort = 80;
}

if(!get_port_state(dmcPort))
{
  exit(0);
}

foreach path (make_list("/", "/DMC", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/titleBar.php"), port:dmcPort);
  rcvRes = http_send_recv(port:dmcPort, data:sndReq);
  if("DB2 Monitoring Console" >< rcvRes)
  {
    dmcVer = eregmatch(pattern:'"IBM">v([0-9.]+)', string:rcvRes);
    if(dmcVer[1] != NULL){
      set_kb_item(name:"www/" + dmcPort + "/IBM/DB2MC",value:dmcVer[1] + " under " + path);
    }
  }
}
