###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_icq_toolbar_actvx_ctrl_dos_vuln.nasl 4468 2009-09-03 13:12:24Z sep $
#
# ICQ Toolbar 'toolbaru.dll' ActiveX Control Remote DOS Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800694);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-7135", "CVE-2008-7136");
  script_bugtraq_id(28086, 28118);
  script_name("ICQ Toolbar 'toolbaru.dll' ActiveX Control Remote DOS Vulnerability");
  desc = "
  Overview: This host has ICQ Toolbar installed and is prone to Remote
  Denial of Service Vulnerability

  Vulnerability Insight:
  This flaw is due to an error in 'toolbaru.dll' when processing a long argument
  to the (1) RequestURL, (2) GetPropertyById, (3) SetPropertyById or (4) IsChecked
  method.

  Impact:
  Successful exploitation allows remote attackers to crash the toolbar.

  Impact Level: Application

  Affected Software/OS:
  ICQ Toolbar version 2.3 beta and prior.

  Fix:
  No solution or patch is available as on 03rd September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://download.icq.com/download/toolbar

  References:
  http://www.milw0rm.com/exploits/5217
  http://xforce.iss.net/xforce/xfdb/41014
  http://www.securiteam.com/exploits/5WP0115NPU.html

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of ICQ Toolbar");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_icq_toolbar_detect.nasl");
  script_require_keys("ICQ/Toolbar/Ver");
  script_require_ports(139, 445);
  exit(0);
}

include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

cqVer = get_kb_item("ICQ/Toolbar/Ver");
if(!cqVer)
{
  exit(0);
}

path=registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion\",
                                              item:"ProgramFilesDir");
path = path + "\ICQToolbar\toolbaru.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path);

dllSize = get_file_size(share:share, file:file);
if(dllSize)
{
  if(version_is_less_equal(version:icqVer, test_version:"2.3.beta"))
  {
    if(is_killbit_set(clsid:"{855F3B16-6D32-4FE6-8A56-BBB695989046") == 0){
      security_warning(0);
    }
  }
}
