###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_icq_toolbar_detect.nasl 4468 2009-09-03 12:37:29Z sep $
#
# ICQ Toolbar Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800693);
  script_version("$Revision: 1.0$");
  script_name("ICQ Toolbar version detection");
  desc = "
  Overview: This script detects the installed version of ICQ Toolbar and
  sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of ICQ Toolbar");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

Key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:Key)){
    exit(0);
}

foreach item (registry_enum_keys(key:Key))
{
  icqName = registry_get_sz(key:Key + item, item:"DisplayName");
  if("ICQ" >< icqName)
  {
    path = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion\",
                                                    item:"ProgramFilesDir");

    foreach file (make_list("\ICQToolbar\version.txt","\ICQ6Toolbar\version.txt"))
    {
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path + file);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path + file );

      icqVer = read_file(share:share, file:file, offset:0, count:25);
      icqVer = ereg_replace(pattern:"[-| ]", replace:".", string:icqVer);
      if(icqVer){
        set_kb_item(name:"ICQ/Toolbar/Ver", value:icqVer);
      }
    }
  }
}
