###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ipsec-tools_detect.nasl 2180 2009-05-11 18:19:29Z may $
#
# IPSec Tools Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800707);
  script_version("$Revision: 1.0 $");
  script_name("IPSec Tools Version Detection");
  desc = "

  Overview: The script detects the version of IPSec Tools for Linux on
  remote host and sets the result into KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Check for IPSec Tools version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

ipsecPaths = find_file(file_name:"setkey", file_path:"/", useregex:TRUE,
                       regexpar:"$", sock:sock);
foreach ipsecBin (ipsecPaths)
{
  ipsecVer = get_bin_version(full_prog_name:chomp(ipsecBin), sock:sock,
                             version_argv:"-V",
                             ver_pattern:"ipsec-tools ([0-9.]+)");
  if(ipsecVer[1] != NULL)
  {
    set_kb_item(name:"IPSec/Tools/Ver", value:ipsecVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
