###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_k-meleon_detect.nasl 4380 2009-09-04 10:36:29Z sep $
#
# K-Meleon Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800891);
  script_version("$Revision: 1.0 $");
  script_name("K-Meleon Version Detection");
  desc = "
  Overview: This script detects the installed version of K-Meleon Browser
  and sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of K-Meleon Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

path = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\K-Meleon";
kmeleonName = registry_get_sz(key:path, item:"DisplayName");

if("K-Meleon" >< kmeleonName)
{
  kmeleonVer = registry_get_sz(key:path, item:"DisplayVersion");
  if(isnull(kmeleonVer))
  {
    kmeleonPath = registry_get_sz(key:path, item:"UninstallString");
    kmeleonPath = ereg_replace(pattern:'"', replace:"", string:kmeleonPath);

    readme = kmeleonPath - "nsuninst.exe" - "Uninstall.exe" + "readme.txt";
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:readme);
    rfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:readme);
    readFile = read_file(file:rfile, share:share, offset:0, count:2000);

    ver = eregmatch(pattern:"v([0-9.]+)", string:readFile);
    if(!isnull(ver[1]))
      kmeleonVer = ver[1];
  }
  if(!isnull(kmeleonVer)){
    set_kb_item(name:"K-Meleon/Ver", value:kmeleonVer);
  }
}
