##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_kaspersky_av_2010_dos_vuln.nasl 5989 2009-12-05 12:03:46Z dec $
#
# Kaspersky Anti-Virus 2010 'kl1.sys' Driver DoS Vulnerability
#
# Authors:
# Veerendra GG <veernedragg@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800154);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4114");
  script_bugtraq_id(37044);
  script_name("Kaspersky Anti-Virus 2010 'kl1.sys' Driver DoS Vulnerability");
  desc = "
  Overview: The host is installed with Kaspersky Anti-Virus 2010 and is prone
  to Denial of Service vulnerability.

  Vulnerability Insight:
  The flaw is due to NULL pointer dereference in 'kl1.sys' driver via a
  specially-crafted IOCTL 0x0022c008 call.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code with
  elevated privileges or cause the kernel to crash.

  Impact Level: System/Application

  Affected Software/OS:
  Kaspersky Anti-Virus 2010 before 9.0.0.736 on Windows.

  Fix: Update to version 9.0.0.736 or later,
  For Updates Refer, http://www.kaspersky.com/downloads

  References:
  http://secunia.com/advisories/37398
  http://xforce.iss.net/xforce/xfdb/54309
  http://www.securityfocus.com/archive/1/archive/1/507933/100/0/threaded

  CVSS Score:
    CVSS Base Score      : 4.9 (AV:L/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score  : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Kaspersky Anti-Virus");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_kaspersky_av_detect.nasl");
  exit(0);
}


include("version_func.inc");

## Get Version from KB
kavVer = get_kb_item("Kaspersky/AV/Ver");
if(kavVer != NULL)
{
  ## Kaspersky Anti-Virus 2010 before 9.0.0.736
  if(version_in_range(version:kavVer, test_version:"9.0", test_version2:"9.0.0.735")){
    security_warning(0);
  }
}
