###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_limny_detect.nasl 7455 2010-03-01 10:20:36Z mar $
#
# Limny Version Detection
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800295);
  script_version("$Revision: 6868 $: 1.0");
  script_name("Limny Version Detection");
  desc = "
  Overview: This script finds the installed Limny version and saves
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of Limny in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

limPort = get_http_port(default:80);
if(!limPort){
  limPort = 80;
}

if(!get_port_state(limPort)){
  exit(0);
}

foreach dir (make_list("/limny", "/limny/upload", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir , "/index.php"), port:limPort);
  rcvRes = http_send_recv(port:limPort, data:sndReq);
  if("Limny" >< rcvRes)
  {
    limVer = eregmatch(pattern:"Limny ([0-9.]+)" , string:rcvRes);
    if(limVer[1] != NULL){
      set_kb_item(name:"www/" + limPort + "/Limny", value:limVer[1] + " under " + dir);
    }
  }
}
