##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_limny_mult_csrf_vuln.nasl 7455 2010-03-01 10:33:29 mar $
#
# Limny Multiple Cross-site Request Forgery (CSRF) Vulnerabilities
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800296);
  script_version("$Revision: 6868 $: 1.0");
  script_cve_id("CVE-2010-0709");
  script_name("Limny Multiple Cross-site Request Forgery (CSRF) Vulnerabilities");
  desc = "
  Overview: This host is running Limny is prone to multiple cross-site request
  forgery vulnerabilities

  Vulnerability Insight:
  The multiple flaws are caused by improper validation of user-supplied input,
  which allows users to perform certain actions via HTTP requests without
  performing any validity checks to verify the requests.

  Impact:
  Successful exploitation will allow remote attackers to change the administrative
  password or email address and add a new user by tricking an administrative user
  into visiting a malicious web site.

  Impact Level: Application.

  Affected Software:
  Limny version 2.0

  Fix:Upgrade to Limny version 2.01
  For updates refer, http://www.limny.org/

  References:
  http://secunia.com/advisories/38616
  http://xforce.iss.net/xforce/xfdb/56318
  http://www.exploit-db.com/exploits/11478

  CVSS Score:
    CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.3
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Limny");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_limny_detect.nasl");
  exit(0);
}


include("version_func.inc");
include("http_func.inc");

limPort = get_http_port(default:80);
if(!limPort){
  exit(0);
}

limVer = get_kb_item("www/" + limPort + "/Limny");
if(!limVer){
  exit(0);
}

limVer= eregmatch(pattern:"^(.+) under (/.*)$", string:limVer);
if(limVer[1] != NULL)
{
  if(version_is_less_equal(version:limVer[1], test_version:"2.0")){
    security_hole(limPort);
  }
}
