###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_linkspheric_detect.nasl 5169 2009-10-08 10:10:24Z oct $
#
# linkSpheric Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801112);
  script_version("$Revision: 1.0 $");
  script_name("linkSpheric Version Detection");
  desc = "
  Overview: This script detects the installed version of linkSpheric and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set version of linkSpheric in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

spheric_port = get_http_port(default:80);
if(!spheric_port){
  spheric_port = 80;
}

if(!get_port_state(spheric_port)){
  exit(0);
}

foreach dir (make_list("/linkSpheric", "/Spheric", "/", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/admin/index.php", port:spheric_port);
  rcvRes = http_send_recv(port:spheric_port, data:sndReq);

  if("linkSpheric" >< rcvRes )
  {
    version = eregmatch(pattern:"linkSpheric version ([0-9.]+( Beta [0-9.])?)",
                        string:rcvRes, icase:1);
    if(isnull(version))
    {
      sndReq = http_get(item:dir + "/CHANGELOG", port:spheric_port);
      rcvRes = http_send_recv(port:spheric_port, data:sndReq);
      version = egrep(pattern:"version [0-9.]+[a-z0-9 ]+(release)",
                      string:rcvRes, icase:1);
      version = eregmatch(pattern:"version ([0-9.]+( Beta [0-9])?)",
                          string:version, icase:1);
    }
    spheric_ver[1] = ereg_replace(pattern:" ", replace:".", string:version[1]);

    if(!isnull(spheric_ver[1]))
    {
      set_kb_item(name:"www/" + spheric_port + "/linkSpheric",
                  value:spheric_ver[1] + " under " + dir);
    }
  }
}
