###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_lunascape_detect.nasl 4377 2009-09-04 15:13:29Z sep $
#
# Lunascape Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800893);
  script_version("$Revision: 1.0 $");
  script_name("Lunascape Version Detection");
  desc = "
  Overview: This script detects the installed version of Lunascape Browser
  and sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Lunascape Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

luna = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (make_list("Lunascape4", "Lunascape5"))
{
  lunaName = registry_get_sz(key:luna + item, item:"DisplayName");

  if("Lunascape" >< lunaName)
  {
    lunaPath = registry_get_sz(key:luna + item, item:"UninstallString");
    if(lunaPath)
    {
      lunaPath = lunaPath - "Uninstall.exe" +  "Luna.exe";
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:lunaPath);
      lfile = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:lunaPath);
      lunaVer = GetVer(file:lfile, share:share);
    }

    if(!isnull(lunaVer)){
     set_kb_item(name:"Lunascape/Ver", value:lunaVer);
    }
  }
}
