###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_magic_iso_maker_bof_vuln.nasl 1564 2009-04-08 12:30:29Z apr $
#
# Magic ISO Maker Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800273);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1257");
  script_name("Magic ISO Maker Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is running Magic ISO Maker and is prone to Heap-Based
  Buffer Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to inadequate boundary check while processing 'CCD'
  image files.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in
  the context of the application and can cause Heap Overflow.

  Impact level: Application

  Affected Software/OS:
  Magic ISO Maker version 5.5 build 274 and prior.

  Fix: No solution or patch is available as on 09th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  updates refer, http://www.magiciso.com/download.htm

  References:
  http://secunia.com/advisories/34595
  http://www.milw0rm.com/exploits/8343
  http://www.vupen.com/english/advisories/2009/0940

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Magic ISO Maker");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_magic_iso_maker_detect.nasl");
  script_require_keys("MagicISOMaker/Ver");
  exit(0);
}


include("version_func.inc");

magicVer = get_kb_item("MagicISOMaker/Ver");
if(!magicVer){
  exit(0);
}

# Grep for Magic ISO maker version 5.5.0274 or prior.
if(version_is_less_equal(version:magicVer, test_version:"5.5.0274")){
  security_hole(0);
}
