##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_maildrop_priv_esc_vuln.nasl 7136 2010-02-08 12:33:29 feb $
#
# Maildrop Privilege Escalation Vulnerability.
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################i###############################################

if(description)
{
  script_id(800292);
  script_version("$Revision: 6681 $: 1.0");
  script_cve_id("CVE-2010-0301");
  script_name("Maildrop Privilege Escalation Vulnerability");
  desc = "
  Overview: This host is installed Maildrop and is prone to Privilege Escalation
  vulnerability

  Vulnerability Insight:
  The flaw is caused due to the error in the 'maildrop/main.C', when run by root
  with the '-d' option, uses the gid of root for execution of the mailfilter file
  in a user's home directory.

  Impact:
  Successful exploitation will allow local users to gain elevated privileges.

  Impact Level: Application.

  Affected Software :
  Maildrop version 2.3.0 and prior.

  Fix: Upgrade to Maildrop version 2.4.0
  For Updates Refer, http://sourceforge.net/projects/courier/files/

  References:
  http://secunia.com/advisories/38367
  http://xforce.iss.net/xforce/xfdb/55980
  http://securitytracker.com/alerts/2010/Jan/1023515.html

  CVSS Score:
   CVSS Base Score       : 6.9 (AV:L/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 5.1
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Maildrop");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_maildrop_detect.nasl");
  exit(0);
}


include("version_func.inc");

mailVer = get_kb_item("Maildrop/Linux/Ver");
if(!mailVer){
  exit(0);
}

if(version_is_less_equal(version:mailVer, test_version:"2.3.0")){
  security_hole(0);
}
