###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mandriva-doc MDKA-2007:014 (mandriva-doc)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830038);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:014");
  script_cve_id("");
  script_name( "Mandriva Update for mandriva-doc MDKA-2007:014 (mandriva-doc)");
  desc = "

  Vulnerability Insight:

  Due to changes in the structure of the documentation, the Help buttons
  of the Software Management tools led to broken links.  This update
  fixes the links catalog system so the inline help works again.

  Affected Software/OS:
  mandriva-doc on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00037.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mandriva-doc");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"mandriva-doc-common-2007", rpm:"mandriva-doc-common-2007~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mandriva-doc-2007", rpm:"mandriva-doc-2007~1.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}