###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gtk+2.0 MDKA-2007:073 (gtk+2.0)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830078);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:073");
  script_cve_id("");
  script_name( "Mandriva Update for gtk+2.0 MDKA-2007:073 (gtk+2.0)");
  desc = "

  Vulnerability Insight:

  With some window managers (such as IceWM or matchbox), or when using
  no window manager, the GTK file chooser was resizing infinitely. This
  bug notably occurred in the save dialog of Mozilla Firefox. This
  update package fixes the issue.

  Affected Software/OS:
  gtk+2.0 on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-06/msg00050.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gtk+2.0");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"gtk+2.0", rpm:"gtk+2.0~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgdk_pixbuf2.0_0", rpm:"libgdk_pixbuf2.0_0~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgdk_pixbuf2.0_0-devel", rpm:"libgdk_pixbuf2.0_0-devel~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtk+-x11", rpm:"libgtk+-x11~2.0_0~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtk+2.0_0", rpm:"libgtk+2.0_0~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtk+2.0_0-devel", rpm:"libgtk+2.0_0-devel~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gdk_pixbuf2.0_0", rpm:"lib64gdk_pixbuf2.0_0~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gdk_pixbuf2.0_0-devel", rpm:"lib64gdk_pixbuf2.0_0-devel~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtk+-x11", rpm:"lib64gtk+-x11~2.0_0~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtk+2.0_0", rpm:"lib64gtk+2.0_0~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtk+2.0_0-devel", rpm:"lib64gtk+2.0_0-devel~2.10.11~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}