###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mozilla-firefox MDKA-2007:086 (mozilla-firefox)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830302);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:086");
  script_cve_id("");
  script_name( "Mandriva Update for mozilla-firefox MDKA-2007:086 (mozilla-firefox)");
  desc = "

  Vulnerability Insight:

  The previous Mozilla Firefox updates did not properly handle the
  default and GNOME themes which prevented buttons from being displayed.
  As well, there were some problems with language support.
  
  These updated packages are being provided to correct the issues.

  Affected Software/OS:
  mozilla-firefox on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-08/msg00006.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mozilla-firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"libmozilla-firefox2.0.0.6", rpm:"libmozilla-firefox2.0.0.6~2.0.0.6~4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmozilla-firefox2.0.0.6-devel", rpm:"libmozilla-firefox2.0.0.6-devel~2.0.0.6~4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox", rpm:"mozilla-firefox~2.0.0.6~4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ar", rpm:"mozilla-firefox-ar~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-bg", rpm:"mozilla-firefox-bg~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-br_FR", rpm:"mozilla-firefox-br_FR~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ca", rpm:"mozilla-firefox-ca~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-cs", rpm:"mozilla-firefox-cs~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-da", rpm:"mozilla-firefox-da~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-de", rpm:"mozilla-firefox-de~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-el", rpm:"mozilla-firefox-el~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-es_AR", rpm:"mozilla-firefox-es_AR~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-es_ES", rpm:"mozilla-firefox-es_ES~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-et_EE", rpm:"mozilla-firefox-et_EE~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-eu", rpm:"mozilla-firefox-eu~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-fi", rpm:"mozilla-firefox-fi~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-fr", rpm:"mozilla-firefox-fr~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-fy", rpm:"mozilla-firefox-fy~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ga", rpm:"mozilla-firefox-ga~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-gu_IN", rpm:"mozilla-firefox-gu_IN~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-he", rpm:"mozilla-firefox-he~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-hu", rpm:"mozilla-firefox-hu~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-it", rpm:"mozilla-firefox-it~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ja", rpm:"mozilla-firefox-ja~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ko", rpm:"mozilla-firefox-ko~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-lt", rpm:"mozilla-firefox-lt~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-mk", rpm:"mozilla-firefox-mk~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-nb_NO", rpm:"mozilla-firefox-nb_NO~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-nl", rpm:"mozilla-firefox-nl~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-nn_NO", rpm:"mozilla-firefox-nn_NO~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-pl", rpm:"mozilla-firefox-pl~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-pt_BR", rpm:"mozilla-firefox-pt_BR~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-pt_PT", rpm:"mozilla-firefox-pt_PT~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ru", rpm:"mozilla-firefox-ru~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-sk", rpm:"mozilla-firefox-sk~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-sl", rpm:"mozilla-firefox-sl~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-sv_SE", rpm:"mozilla-firefox-sv_SE~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-tr", rpm:"mozilla-firefox-tr~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-uk_UA", rpm:"mozilla-firefox-uk_UA~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-zh_CN", rpm:"mozilla-firefox-zh_CN~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-zh_TW", rpm:"mozilla-firefox-zh_TW~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-l10n", rpm:"mozilla-firefox-l10n~2.0.0.6~2.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox2.0.0.6", rpm:"lib64mozilla-firefox2.0.0.6~2.0.0.6~4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox2.0.0.6-devel", rpm:"lib64mozilla-firefox2.0.0.6-devel~2.0.0.6~4mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"libmozilla-firefox2.0.0.6", rpm:"libmozilla-firefox2.0.0.6~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmozilla-firefox2.0.0.6-devel", rpm:"libmozilla-firefox2.0.0.6-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnspr4", rpm:"libnspr4~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnspr4-devel", rpm:"libnspr4-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnspr4-static-devel", rpm:"libnspr4-static-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnss3", rpm:"libnss3~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnss3-devel", rpm:"libnss3-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox", rpm:"mozilla-firefox~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ar", rpm:"mozilla-firefox-ar~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-bg", rpm:"mozilla-firefox-bg~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-br_FR", rpm:"mozilla-firefox-br_FR~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ca", rpm:"mozilla-firefox-ca~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-cs", rpm:"mozilla-firefox-cs~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-da", rpm:"mozilla-firefox-da~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-de", rpm:"mozilla-firefox-de~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-el", rpm:"mozilla-firefox-el~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-es_AR", rpm:"mozilla-firefox-es_AR~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-es_ES", rpm:"mozilla-firefox-es_ES~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-et_EE", rpm:"mozilla-firefox-et_EE~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-eu", rpm:"mozilla-firefox-eu~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-fi", rpm:"mozilla-firefox-fi~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-fr", rpm:"mozilla-firefox-fr~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-fy", rpm:"mozilla-firefox-fy~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ga", rpm:"mozilla-firefox-ga~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-gu_IN", rpm:"mozilla-firefox-gu_IN~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-he", rpm:"mozilla-firefox-he~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-hu", rpm:"mozilla-firefox-hu~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-it", rpm:"mozilla-firefox-it~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ja", rpm:"mozilla-firefox-ja~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ko", rpm:"mozilla-firefox-ko~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-lt", rpm:"mozilla-firefox-lt~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-mk", rpm:"mozilla-firefox-mk~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-nb_NO", rpm:"mozilla-firefox-nb_NO~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-nl", rpm:"mozilla-firefox-nl~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-nn_NO", rpm:"mozilla-firefox-nn_NO~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-pl", rpm:"mozilla-firefox-pl~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-pt_BR", rpm:"mozilla-firefox-pt_BR~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-pt_PT", rpm:"mozilla-firefox-pt_PT~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-ru", rpm:"mozilla-firefox-ru~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-sk", rpm:"mozilla-firefox-sk~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-sl", rpm:"mozilla-firefox-sl~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-sv_SE", rpm:"mozilla-firefox-sv_SE~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-tr", rpm:"mozilla-firefox-tr~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-uk_UA", rpm:"mozilla-firefox-uk_UA~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-zh_CN", rpm:"mozilla-firefox-zh_CN~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-zh_TW", rpm:"mozilla-firefox-zh_TW~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mozilla-firefox-l10n", rpm:"mozilla-firefox-l10n~2.0.0.6~2.1mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox2.0.0.6", rpm:"lib64mozilla-firefox2.0.0.6~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mozilla-firefox2.0.0.6-devel", rpm:"lib64mozilla-firefox2.0.0.6-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nspr4", rpm:"lib64nspr4~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nspr4-devel", rpm:"lib64nspr4-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nspr4-static-devel", rpm:"lib64nspr4-static-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nss3", rpm:"lib64nss3~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nss3-devel", rpm:"lib64nss3-devel~2.0.0.6~4mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}