###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for cdrecord MDKA-2007:093 (cdrecord)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830273);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKA", value: "2007:093");
  script_cve_id("");
  script_name( "Mandriva Update for cdrecord MDKA-2007:093 (cdrecord)");
  desc = "

  Vulnerability Insight:

  Mkisofs program in Mandriva Linux 2007.0 would create ISO images with
  broken Joliet (-J option) file names, when using non-ascii characters.
  
  The updated mkisofs package fixes this issue.

  Affected Software/OS:
  cdrecord on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-10/msg00005.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of cdrecord");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"cdrecord", rpm:"cdrecord~2.01.01~0.a11.2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cdrecord-cdda2wav", rpm:"cdrecord-cdda2wav~2.01.01~0.a11.2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cdrecord-devel", rpm:"cdrecord-devel~2.01.01~0.a11.2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cdrecord-isotools", rpm:"cdrecord-isotools~2.01.01~0.a11.2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cdrecord-vanilla", rpm:"cdrecord-vanilla~2.01.01~0.a11.2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mkisofs", rpm:"mkisofs~2.01.01~0.a11.2.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}