###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdeutils MDVA-2008:046 (kdeutils)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830671);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:046");
  script_cve_id("");
  script_name( "Mandriva Update for kdeutils MDVA-2008:046 (kdeutils)");
  desc = "

  Vulnerability Insight:

  Mozilla Firefox on Mandriva Linux 2008.0 was not able to properly
  handle zip files if only Ark was installed due to a missing mimetype
  in Ark.
  
  This update provides the proper mimetype so zip files will be properly
  handled in Mozilla Firefox.

  Affected Software/OS:
  kdeutils on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-04/msg00013.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdeutils");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"kdeutils", rpm:"kdeutils~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-ark", rpm:"kdeutils-ark~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-common", rpm:"kdeutils-common~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kcalc", rpm:"kdeutils-kcalc~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kcharselect", rpm:"kdeutils-kcharselect~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kdessh", rpm:"kdeutils-kdessh~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kdf", rpm:"kdeutils-kdf~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kedit", rpm:"kdeutils-kedit~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kfloppy", rpm:"kdeutils-kfloppy~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kgpg", rpm:"kdeutils-kgpg~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-khexedit", rpm:"kdeutils-khexedit~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kjots", rpm:"kdeutils-kjots~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-klaptop", rpm:"kdeutils-klaptop~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-ksim", rpm:"kdeutils-ksim~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-ktimer", rpm:"kdeutils-ktimer~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-kwalletmanager", rpm:"kdeutils-kwalletmanager~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdeutils-superkaramba", rpm:"kdeutils-superkaramba~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdeutils1-common", rpm:"libkdeutils1-common~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdeutils1-common-devel", rpm:"libkdeutils1-common-devel~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdeutils1-khexedit", rpm:"libkdeutils1-khexedit~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdeutils1-klaptop", rpm:"libkdeutils1-klaptop~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkdeutils1-ksim", rpm:"libkdeutils1-ksim~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdeutils1-common", rpm:"lib64kdeutils1-common~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdeutils1-common-devel", rpm:"lib64kdeutils1-common-devel~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdeutils1-khexedit", rpm:"lib64kdeutils1-khexedit~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdeutils1-klaptop", rpm:"lib64kdeutils1-klaptop~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kdeutils1-ksim", rpm:"lib64kdeutils1-ksim~3.5.7~9.4mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}