###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for freeradius MDVA-2008:054 (freeradius)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830537);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:054");
  script_cve_id("");
  script_name( "Mandriva Update for freeradius MDVA-2008:054 (freeradius)");
  desc = "

  Vulnerability Insight:

  The freeradius package included in Mandriva Linux 2008.1 had hardcoded
  the use of the '-y' option in its initscript, which is no longer
  a valid option in the new major version of 2.0.  As a result, the
  initscript was unable to launch the service correctly.  As well,
  a file name error in the EAP module configuration triggered an error
  at launch.
  
  Both issues are corrected with this update package.

  Affected Software/OS:
  freeradius on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-05/msg00000.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of freeradius");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"freeradius", rpm:"freeradius~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-krb5", rpm:"freeradius-krb5~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-ldap", rpm:"freeradius-ldap~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-mysql", rpm:"freeradius-mysql~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-postgresql", rpm:"freeradius-postgresql~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"freeradius-unixODBC", rpm:"freeradius-unixODBC~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius1", rpm:"libfreeradius1~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libfreeradius-devel", rpm:"libfreeradius-devel~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius1", rpm:"lib64freeradius1~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64freeradius-devel", rpm:"lib64freeradius-devel~2.0.0~8.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}