###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libgnomeui2 MDVA-2008:100 (libgnomeui2)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830462);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:100");
  script_cve_id("");
  script_name( "Mandriva Update for libgnomeui2 MDVA-2008:100 (libgnomeui2)");
  desc = "

  Vulnerability Insight:

  A missing initialization was preventing correct text rendering in
  the GTK2 file selector, when using non-UTF8 locales.  This updated
  package fixes this issue, as well as memory leaks and also includes
  new translations from the GNOME 2.22.2 release.

  Affected Software/OS:
  libgnomeui2 on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-07/msg00001.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libgnomeui2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libgnomeui2_0", rpm:"libgnomeui2_0~2.22.1~3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgnomeui2", rpm:"libgnomeui2~2.22.1~3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgnomeui2-devel", rpm:"libgnomeui2-devel~2.22.1~3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gnomeui2_0", rpm:"lib64gnomeui2_0~2.22.1~3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gnomeui2-devel", rpm:"lib64gnomeui2-devel~2.22.1~3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}