###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for x11-server MDVA-2008:117 (x11-server)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830714);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:117");
  script_cve_id("");
  script_name( "Mandriva Update for x11-server MDVA-2008:117 (x11-server)");
  desc = "

  Vulnerability Insight:

  This update fixes an X server crash with multiple indirect rendering
  clients and software rendering.

  Affected Software/OS:
  x11-server on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-08/msg00007.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of x11-server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libmesagl1", rpm:"libmesagl1~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesagl1-devel", rpm:"libmesagl1-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglu1", rpm:"libmesaglu1~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglu1-devel", rpm:"libmesaglu1-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglut3", rpm:"libmesaglut3~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglut3-devel", rpm:"libmesaglut3-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglw1", rpm:"libmesaglw1~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libmesaglw1-devel", rpm:"libmesaglw1-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa", rpm:"mesa~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa-common-devel", rpm:"mesa-common-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa-demos", rpm:"mesa-demos~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mesa-source", rpm:"mesa-source~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server", rpm:"x11-server~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-common", rpm:"x11-server-common~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-devel", rpm:"x11-server-devel~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xati", rpm:"x11-server-xati~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xchips", rpm:"x11-server-xchips~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xdmx", rpm:"x11-server-xdmx~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xephyr", rpm:"x11-server-xephyr~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xepson", rpm:"x11-server-xepson~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xfake", rpm:"x11-server-xfake~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xfbdev", rpm:"x11-server-xfbdev~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xi810", rpm:"x11-server-xi810~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmach64", rpm:"x11-server-xmach64~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmga", rpm:"x11-server-xmga~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xneomagic", rpm:"x11-server-xneomagic~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xnest", rpm:"x11-server-xnest~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xnvidia", rpm:"x11-server-xnvidia~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xorg", rpm:"x11-server-xorg~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xpm2", rpm:"x11-server-xpm2~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xr128", rpm:"x11-server-xr128~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xsdl", rpm:"x11-server-xsdl~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xsmi", rpm:"x11-server-xsmi~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvesa", rpm:"x11-server-xvesa~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvfb", rpm:"x11-server-xvfb~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvia", rpm:"x11-server-xvia~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvnc", rpm:"x11-server-xvnc~1.3.0.0~25.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesagl1", rpm:"lib64mesagl1~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesagl1-devel", rpm:"lib64mesagl1-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglu1", rpm:"lib64mesaglu1~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglu1-devel", rpm:"lib64mesaglu1-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglut3", rpm:"lib64mesaglut3~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglut3-devel", rpm:"lib64mesaglut3-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglw1", rpm:"lib64mesaglw1~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64mesaglw1-devel", rpm:"lib64mesaglw1-devel~7.0.1~11.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}