###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for blt MDVA-2008:121 (blt)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830642);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:121");
  script_cve_id("");
  script_name( "Mandriva Update for blt MDVA-2008:121 (blt)");
  desc = "

  Vulnerability Insight:

  An updated blt package is provided that fixes two issues.
  
  The first is that the package contains two symlinks named
  /usr/bin/bltsh and /usr/bin/bltwish that were intended to make it
  easier to launch these two utilities.  However, they were linked to
  files that did not exist, and consequently did not work.
  
  The second is that neither utility will actually run when launched
  correctly: they complain that Tcl version 8.5.1 is present, but
  that version 8.5 is needed.  This over-enthusiastic version check
  is dampened by the update, resulting in the utilities both running
  as expected.

  Affected Software/OS:
  blt on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00011.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of blt");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"blt", rpm:"blt~2.4z~15.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"blt-scripts", rpm:"blt-scripts~2.4z~15.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libblt2", rpm:"libblt2~2.4z~15.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libblt2-devel", rpm:"libblt2-devel~2.4z~15.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64blt2", rpm:"lib64blt2~2.4z~15.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64blt2-devel", rpm:"lib64blt2-devel~2.4z~15.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}