###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for phonon MDVA-2008:153 (phonon)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830402);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:153");
  script_cve_id("");
  script_name( "Mandriva Update for phonon MDVA-2008:153 (phonon)");
  desc = "

  Vulnerability Insight:

  In Mandriva Linux 2009.0, phonon's signal
  availableAudioCaptureDevicesChanged was not connected, causing the
  KDE4 desktop to be unable to play OGG files.  This update corrects
  the issue.

  Affected Software/OS:
  phonon on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00033.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of phonon");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"libphonon4", rpm:"libphonon4~4.2.0~13.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libphononexperimental4", rpm:"libphononexperimental4~4.2.0~13.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"phonon-devel", rpm:"phonon-devel~4.2.0~13.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"phonon-gstreamer", rpm:"phonon-gstreamer~4.2.0~13.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"phonon", rpm:"phonon~4.2.0~13.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64phonon4", rpm:"lib64phonon4~4.2.0~13.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64phononexperimental4", rpm:"lib64phononexperimental4~4.2.0~13.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}