###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdebase4-runtime MDVA-2008:155 (kdebase4-runtime)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830755);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:155");
  script_cve_id("");
  script_name( "Mandriva Update for kdebase4-runtime MDVA-2008:155 (kdebase4-runtime)");
  desc = "

  Vulnerability Insight:

  When an attachment file is opened in a KDE4 application, it is copied
  to a temporary directory and opened by a 'kioexec' process. When you
  close the application, the 'kioexec' process should automatically
  close after some minutes of inactivity in the temporary file. The
  kdebase4-runtime package released in Mandriva Linux 2009 has a bug
  which prevents the 'kioexec' process from closing.
  
  This update fixes the problem.

  Affected Software/OS:
  kdebase4-runtime on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-10/msg00035.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdebase4-runtime");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"kdebase4-runtime", rpm:"kdebase4-runtime~4.1.2~3.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase4-runtime-devel", rpm:"kdebase4-runtime-devel~4.1.2~3.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkaudiodevicelist4", rpm:"libkaudiodevicelist4~4.1.2~3.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"oxygen-icon-theme", rpm:"oxygen-icon-theme~4.1.2~3.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"phonon-xine", rpm:"phonon-xine~4.1.2~3.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64kaudiodevicelist4", rpm:"lib64kaudiodevicelist4~4.1.2~3.2mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}