###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for evolution MDVA-2008:186 (evolution)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830446);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:186");
  script_cve_id("");
  script_name( "Mandriva Update for evolution MDVA-2008:186 (evolution)");
  desc = "

  Vulnerability Insight:

  Outgoing mails sent through the Evolution Exchange plugin were not
  always sent properly.  Spell checking was not working properly when
  two different languages were enabled, causing all words to be detected
  as mistyped.  Those bugs are fixed by this package updates, as well
  as massive performance improvements in IMAP handling, additional
  translations and many bug fixes from GNOME 2.24.2.

  Affected Software/OS:
  evolution on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-12/msg00000.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of evolution");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"evolution", rpm:"evolution~2.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-data-server", rpm:"evolution-data-server~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-devel", rpm:"evolution-devel~2.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-exchange", rpm:"evolution-exchange~2.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-mono", rpm:"evolution-mono~2.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"evolution-pilot", rpm:"evolution-pilot~2.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gtkhtml", rpm:"gtkhtml~3.14~3.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libcamel14", rpm:"libcamel14~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libebackend0", rpm:"libebackend0~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libebook9", rpm:"libebook9~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libecal7", rpm:"libecal7~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libedata-book2", rpm:"libedata-book2~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libedata-cal6", rpm:"libedata-cal6~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libedataserver11", rpm:"libedataserver11~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libedataserver-devel", rpm:"libedataserver-devel~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libedataserverui8", rpm:"libedataserverui8~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libegroupwise13", rpm:"libegroupwise13~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libexchange-storage3", rpm:"libexchange-storage3~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgdata1", rpm:"libgdata1~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtkhtml", rpm:"libgtkhtml~3.14_19~3.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libgtkhtml", rpm:"libgtkhtml~3.14~devel~3.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64camel14", rpm:"lib64camel14~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ebackend0", rpm:"lib64ebackend0~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ebook9", rpm:"lib64ebook9~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64ecal7", rpm:"lib64ecal7~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64edata-book2", rpm:"lib64edata-book2~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64edata-cal6", rpm:"lib64edata-cal6~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64edataserver11", rpm:"lib64edataserver11~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64edataserver-devel", rpm:"lib64edataserver-devel~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64edataserverui8", rpm:"lib64edataserverui8~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64egroupwise13", rpm:"lib64egroupwise13~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64exchange-storage3", rpm:"lib64exchange-storage3~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gdata1", rpm:"lib64gdata1~2.24.2~2.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtkhtml", rpm:"lib64gtkhtml~3.14_19~3.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64gtkhtml", rpm:"lib64gtkhtml~3.14~devel~3.24.2~1.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}