###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kdebase4 MDVA-2010:012 (kdebase4)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830790);
  script_version("$Revision: 6414 $: 1.0");
  script_xref(name: "MDVA", value: "2010:012");
  script_name("Mandriva Update for kdebase4 MDVA-2010:012 (kdebase4)");
  desc = "

  Vulnerability Insight:

  In kde4.3 this is not possible to execute a bash script when double
  clicking on it.
  
  This update fixes this issue.

  Affected Software/OS:
  kdebase4 on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00015.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdebase4");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"dolphin", rpm:"dolphin~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kappfinder", rpm:"kappfinder~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kde4-nsplugins", rpm:"kde4-nsplugins~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase4", rpm:"kdebase4~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdebase4-devel", rpm:"kdebase4-devel~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdepasswd", rpm:"kdepasswd~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kdialog", rpm:"kdialog~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"keditbookmarks", rpm:"keditbookmarks~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kfind", rpm:"kfind~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kinfocenter", rpm:"kinfocenter~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"konqueror", rpm:"konqueror~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"konsole", rpm:"konsole~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kwrite", rpm:"kwrite~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdolphinprivate4", rpm:"libdolphinprivate4~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkonq5", rpm:"libkonq5~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkonqsidebarplugin4", rpm:"libkonqsidebarplugin4~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libkonquerorprivate4", rpm:"libkonquerorprivate4~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"plasma-applet-folderview", rpm:"plasma-applet-folderview~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dolphinprivate4", rpm:"lib64dolphinprivate4~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64konq5", rpm:"lib64konq5~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64konqsidebarplugin4", rpm:"lib64konqsidebarplugin4~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64konquerorprivate4", rpm:"lib64konquerorprivate4~4.3.2~3.10mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}