###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for dbus-glib MDVA-2010:039 (dbus-glib)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830839);
  script_version("$Revision: 6485 $: 1.0");
  script_xref(name: "MDVA", value: "2010:039");
  script_name("Mandriva Update for dbus-glib MDVA-2010:039 (dbus-glib)");
  desc = "

  Vulnerability Insight:

  The dbus-glib package was built without a symbol that is needed by
  the latest versions of tracker. This update adds the missing functions
  (#57068).

  Affected Software/OS:
  dbus-glib on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00069.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of dbus-glib");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"libdbus-glib-1_2", rpm:"libdbus-glib-1_2~0.82~1.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libdbus-glib-1_2-devel", rpm:"libdbus-glib-1_2-devel~0.82~1.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dbus-glib", rpm:"dbus-glib~0.82~1.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-glib-1_2", rpm:"lib64dbus-glib-1_2~0.82~1.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64dbus-glib-1_2-devel", rpm:"lib64dbus-glib-1_2-devel~0.82~1.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}