###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mmc-wizard MDVA-2010:040 (mmc-wizard)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830843);
  script_version("$Revision: 6485 $: 1.0");
  script_xref(name: "MDVA", value: "2010:040");
  script_name("Mandriva Update for mmc-wizard MDVA-2010:040 (mmc-wizard)");
  desc = "

  Vulnerability Insight:

  A dependency problem was discovered with roundcube. The
  php-pear-MDB2_Driver_sqlite dependency was added for mmc-wizard to
  address this problem.

  Affected Software/OS:
  mmc-wizard on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00071.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mmc-wizard");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"mmc-wizard", rpm:"mmc-wizard~1.0~13.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}