###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for urpmi MDVA-2010:045 (urpmi)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830856);
  script_version("$Revision: 6589 $: 1.0");
  script_xref(name: "MDVA", value: "2010:045");
  script_name("Mandriva Update for urpmi MDVA-2010:045 (urpmi)");
  desc = "

  Vulnerability Insight:

  There was a small typo in the french translation. The update packages
  addresses this issue.

  Affected Software/OS:
  urpmi on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64,
  Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64,
  Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00082.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of urpmi");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"gurpmi", rpm:"gurpmi~4.10.14.2~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi", rpm:"urpmi~4.10.14.2~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-ldap", rpm:"urpmi-ldap~4.10.14.2~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ka-run", rpm:"urpmi-parallel-ka-run~4.10.14.2~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ssh", rpm:"urpmi-parallel-ssh~4.10.14.2~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-recover", rpm:"urpmi-recover~4.10.14.2~1.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"gurpmi", rpm:"gurpmi~6.14.15~1.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi", rpm:"urpmi~6.14.15~1.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-ldap", rpm:"urpmi-ldap~6.14.15~1.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ka-run", rpm:"urpmi-parallel-ka-run~6.14.15~1.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ssh", rpm:"urpmi-parallel-ssh~6.14.15~1.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-recover", rpm:"urpmi-recover~6.14.15~1.3mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"gurpmi", rpm:"gurpmi~6.25.6~1.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi", rpm:"urpmi~6.25.6~1.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-ldap", rpm:"urpmi-ldap~6.25.6~1.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ka-run", rpm:"urpmi-parallel-ka-run~6.25.6~1.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ssh", rpm:"urpmi-parallel-ssh~6.25.6~1.2mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"gurpmi", rpm:"gurpmi~6.14.15~1.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi", rpm:"urpmi~6.14.15~1.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-ldap", rpm:"urpmi-ldap~6.14.15~1.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ka-run", rpm:"urpmi-parallel-ka-run~6.14.15~1.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-parallel-ssh", rpm:"urpmi-parallel-ssh~6.14.15~1.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"urpmi-recover", rpm:"urpmi-recover~6.14.15~1.3mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}