###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for webkit MDVA-2010:046 (webkit)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830848);
  script_version("$Revision: 6589 $: 1.0");
  script_xref(name: "MDVA", value: "2010:046");
  script_name("Mandriva Update for webkit MDVA-2010:046 (webkit)");
  desc = "

  Vulnerability Insight:

  This update brings a new stable version of webkitgtk, and solves the
  problem with processors without the SSE2 instruction set. It is easy to
  see if you are suffering from this bug, just try to open some webpage
  on epiphany Web broswser, it will crash with old webkit version.

  Affected Software/OS:
  webkit on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-01/msg00083.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of webkit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"libwebkitgtk1.0_2", rpm:"libwebkitgtk1.0_2~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwebkitgtk1.0-devel", rpm:"libwebkitgtk1.0-devel~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"webkit1.0", rpm:"webkit1.0~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"webkit1.0-webinspector", rpm:"webkit1.0-webinspector~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"webkit", rpm:"webkit~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"webkit-gtklauncher", rpm:"webkit-gtklauncher~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"webkit-jsc", rpm:"webkit-jsc~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64webkitgtk1.0_2", rpm:"lib64webkitgtk1.0_2~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64webkitgtk1.0-devel", rpm:"lib64webkitgtk1.0-devel~1.1.15.1~1.2.2mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}