###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for mmc-agent MDVA-2010:050-1 (mmc-agent)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830916);
  script_version("$Revision: 6863 $: 1.0");
  script_xref(name: "MDVA", value: "2010:050-1");
  script_name("Mandriva Update for mmc-agent MDVA-2010:050-1 (mmc-agent)");
  desc = "

  Vulnerability Insight:

  MMC web interface allows to create isos for user's homes and
  shares. With this update, mkisofs has been added as a requirement of
  the package.
  
  Update:
  
  It was discovered the cdrkit-genisoimage package was missing with
  the MDVA-2010:050 advisory. This advisory provides the missing
  dependancies.

  Affected Software/OS:
  mmc-agent on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00053.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mmc-agent");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"cdrkit", rpm:"cdrkit~1.1.8~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cdrkit-genisoimage", rpm:"cdrkit-genisoimage~1.1.8~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cdrkit-icedax", rpm:"cdrkit-icedax~1.1.8~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cdrkit-isotools", rpm:"cdrkit-isotools~1.1.8~2.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}