###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nuface MDVA-2010:057 (nuface)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830871);
  script_version("$Revision: 6743 $: 1.0");
  script_xref(name: "MDVA", value: "2010:057");
  script_name("Mandriva Update for nuface MDVA-2010:057 (nuface)");
  desc = "

  Vulnerability Insight:

  Update to new version. Fix many bugs and add functionalities for
  nuface interface.

  Affected Software/OS:
  nuface on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00015.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nuface");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"libnuclient3", rpm:"libnuclient3~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libnufw-devel", rpm:"libnufw-devel~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nuface", rpm:"nuface~2.0.14~3.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw", rpm:"nufw~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth", rpm:"nufw-nuauth~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-auth-ldap", rpm:"nufw-nuauth-auth-ldap~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-log-mysql", rpm:"nufw-nuauth-log-mysql~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-log-pgsql", rpm:"nufw-nuauth-log-pgsql~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nuauth-log-prelude", rpm:"nufw-nuauth-log-prelude~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-nutcpc", rpm:"nufw-nutcpc~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nufw-utils", rpm:"nufw-utils~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pam_nufw", rpm:"pam_nufw~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"python-nufw", rpm:"python-nufw~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"squid_nufw_helper", rpm:"squid_nufw_helper~1.0.0~0.rc2.5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nuclient3", rpm:"lib64nuclient3~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64nufw-devel", rpm:"lib64nufw-devel~2.2.21~5.1mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}