###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for openoffice.org-voikko MDVA-2010:060 (openoffice.org-voikko)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830875);
  script_version("$Revision: 6743 $: 1.0");
  script_xref(name: "MDVA", value: "2010:060");
  script_name("Mandriva Update for openoffice.org-voikko MDVA-2010:060 (openoffice.org-voikko)");
  desc = "

  Vulnerability Insight:

  The previous update of openoffice.org missed openoffice.org-voikko,
  causing upgrade problems for Finnish users. This update provides
  openoffice.org-voikko for openoffice.org 3.1.1.

  Affected Software/OS:
  openoffice.org-voikko on Mandriva Linux 2009.1,
  Mandriva Linux 2009.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-02/msg00019.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openoffice.org-voikko");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.1")
{

  if(isrpmvuln(pkg:"openoffice.org-voikko", rpm:"openoffice.org-voikko~3.0.1~1.4mdv2009.1", rls:"MNDK_2009.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}