###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for slib MDVA-2010:091 (slib)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830936);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "MDVA", value: "2010:091");
  script_name("Mandriva Update for slib MDVA-2010:091 (slib)");
  desc = "

  Vulnerability Insight:

  Old version of slib was not compatible with some gnucash features,
  which could cause crashes in the application. This bugfix update
  features latest version of slib package and ensure it is correctly
  registering into guile code repository. Additionally improvements was
  done for the guile packages which is also provided with this advisory.

  Affected Software/OS:
  slib on Mandriva Linux 2010.0,
  Mandriva Linux 2010.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-03/msg00008.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of slib");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2010.0")
{

  if(isrpmvuln(pkg:"guile", rpm:"guile~1.8.6~5.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libguile17", rpm:"libguile17~1.8.6~5.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libguile-devel", rpm:"libguile-devel~1.8.6~5.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"slib-3b2", rpm:"slib-3b2~1.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64guile17", rpm:"lib64guile17~1.8.6~5.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64guile-devel", rpm:"lib64guile-devel~1.8.6~5.1mdv2010.0", rls:"MNDK_2010.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}