###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for nulog MDVA-2010:097 (nulog)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830927);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "MDVA", value: "2010:097");
  script_name("Mandriva Update for nulog MDVA-2010:097 (nulog)");
  desc = "

  Vulnerability Insight:

  Add a buildrequire on python-twisted-core to get rid of a file deps
  on /usr/bin/twistd

  Affected Software/OS:
  nulog on Mandriva Enterprise Server 5,
  Mandriva Enterprise Server 5/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2010-03/msg00016.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of nulog");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_mes5")
{

  if(isrpmvuln(pkg:"nulog", rpm:"nulog~2.1.5~0.2mdvmes5", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"nulog", rpm:"nulog~2.1.5~0.2mdvmes2009.0", rls:"MNDK_mes5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}