###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mdpro_detect.nasl 3687 2009-08-06 10:28:24Z aug $
#
# MDPro Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800918);
  script_version("Revision: 1.0 $");
  script_name("MDPro Version Detection");
  desc = "

  Overview: This script detects the installed version of MDPro and sets
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of MDPro");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

mdpro_port = get_http_port(default:80);
if(!mdpro_port){
  mdpro_port = 80;
}

if(!get_port_state(mdpro_port)){
  exit(0);
}

foreach dir (make_list("/mdpro", "/md", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:mdpro_port);
  rcvRes = http_send_recv(port:mdpro_port, data:sndReq);

  if(egrep(pattern:"MD-?Pro", string:rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    mdproVer = eregmatch(pattern:"MD-?Pro ([0-9.]+)", string:rcvRes);
    if(mdproVer[1]!= NULL)
    {
      set_kb_item(name:"www/" + mdpro_port + "/MDPro",
                  value:mdproVer[1] + " under " + dir);
    }
  }
}
