###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_merak_mail_server_detect.nasl 790 2009-01-06 13:49:39Z jan $
#
# Merak Mail Server Web Mail Version Detection
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800096);
  script_version("$Revision: 1.0 $");
  script_name("Merak Mail Server Web Mail Version Detection");
  desc = "

  Overview: This script will detect the version of Merak Mail Server Web Mail
  on the remote host and sets the KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Merak Mail Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("find_service.nes");
  exit(0);
}


include("http_func.inc");

port = 32000;
banner = get_http_banner(port);

if("IceWarp" >!< banner){
  exit(0);
}

smtpPort = get_kb_item("Services/smtp");
if(!smtpPort){
  smtpPort = 25;
}

imapPort = get_kb_item("Services/imap");
if(!imapPort){
  imapPort = 143;
}

popPort = get_kb_item("Services/pop3");
if(!popPort){
  popPort = 110;
}

foreach port (make_list(smtpPort, imapPort, popPort))
{
  banner = get_kb_item(string("Banner/", port));
  if(banner =~ "IceWarp|Merak")
  {
    ver = eregmatch(pattern:"(Merak|IceWarp) ([0-9.]+)", string:banner);
    if(ver[2] != NULL){
      set_kb_item(name:"MerakMailServer/Ver", value:ver[2]);
    }
    exit(0);
  }
}
