###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mongoose_server_info_disc_vuln.nasl 6538 2010-01-08 17:29:24Z jan $
#
# Mongoose Web Server Source Code Disclosure Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800412);
  script_version("$Revision: 6354 $: 1.0");
  script_cve_id("CVE-2009-4530", "CVE-2009-4535");
  script_name("Mongoose Web Server Source Code Disclosure Vulnerability");
  desc = "
  Overview: The host is running Mongoose Web Server and is prone to Source Code
  Disclosure vulnerability.

  Vulnerability Insight:
  The issue is caused due to an error within the handling of HTTP requests and
  can be exploited to disclose the source code of certain scripts (e.g. PHP) by
  appending '::$DATA' or '/' to a URI.

  Impact:
  Successful exploitation will allow remote attackers to display the source code
  of arbitrary files instead of an expected HTML response

  Impact Level: Application

  Affected Software/OS:
  Mongoose Web Server version 2.8 and prior on windows.

  Fix:
  No solution or patch is available as on 08th january, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://code.google.com/p/mongoose/

  References:
  http://freetexthost.com/0lcsrgt3vw
  http://secunia.com/advisories/36934

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for version of Mongoose Web Server");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Web Servers");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

moPort = 80;
if(!get_port_state(moPort))
{
  moPort = 8080 ;
  if(!get_port_state(moPort)){
    exit(0);
  }
}

if(!safe_checks())
{
  sndReq= http_get(item:"/index.php::$DATA", port:moPort);
  rcvRes  = http_keepalive_send_recv(port:moPort, data:sndReq);
  if(!isnull(rcvRes) && "<?php" >< rcvRes && "?>" >< rcvRes){
    security_warning(moPort);
  }
}

