###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mrbs_detect.nasl 5166 2009-10-09 18:58:24Z oct $
#
# Meeting Room Booking System Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800949);
  script_version("Revision: 1.0");
  script_name("Meeting Room Booking System Version Detection");
  desc = "
  Overview: This script detects the installed version of Meeting Room
  Booking System and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of MRBS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

mrbsPort = get_http_port(default:80);
if(!mrbsPort){
  mrbsPort = 80;
}

if(!get_port_state(mrbsPort)){
  exit(0);
}

foreach dir (make_list("/", "/mrbs1261", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/web/help.php"), port:mrbsPort);
  rcvRes = http_send_recv(port:mrbsPort, data:sndReq);

  if(("About MRBS" >< rcvRes || "Meeting Room Booking System" >< rcvRes) &&
      egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    mrbsVer = eregmatch(pattern:"MRBS ([0-9.]+).?([a-zA-Z]+([0-9]+)?)?",
                                                        string:rcvRes);
    if(mrbsVer[1] != NULL)
    {
      if(mrbsVer[2] != NULL)
      {
        mrbsVer = mrbsVer[1] + "." + mrbsVer[2];
      }
      else
        mrbsVer = mrbsVer[1];
      set_kb_item(name:"www/" + mrbsPort + "/MRBS", value:mrbsVer + " under "
                                                                      + dir);
    }
  }
}
