###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mrbs_sql_inj_vuln.nasl 5166 2009-10-09 19:57:11Z oct $
#
# Meeting Room Booking System SQL Injection Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800950);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3533");
  script_name("Meeting Room Booking System SQL Injection Vulnerability");
  desc = "
  Overview: This host is installed with Meeting Room Booking System and is
  prone to SQL Injection vulnerability.

  Vulnerability Insight:
  The user supplied data passed into 'typematch' parameter in report.php is
  not properly sanitised before being used in an SQL query.

  Impact:
  Attackes can exploit this issue to inject arbitrary SQL code and modify
  information in the back-end database.

  Impact Level: Application.

  Affected Software/OS:
  Meeting Room Booking System prior to 1.4.2 on all platforms.

  Fix: Upgrade to Meeting Room Booking System 1.4.2 or later.
  For Updates Refer, http://mrbs.sourceforge.net/download.php

  References:
  http://secunia.com/advisories/35469
  http://xforce.iss.net/xforce/xfdb/51772
  http://mrbs.sourceforge.net/view_text.php?section=NEWS&file=NEWS

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of MRBS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_mrbs_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

mrbsPort = get_http_port(default:80);

if(!mrbsPort){
  exit(0);
}

mrbsVer = get_kb_item("www/" + mrbsPort + "/MRBS");
mrbsVer = eregmatch(pattern:"^(.+) under (/.*)$", string:mrbsVer);

if(mrbsVer[1] != NULL)
{
  if(version_is_less(version:mrbsVer[1], test_version:"1.4.2")){
    security_hole(mrbsPort);
  }
}
