###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_bof_vuln_jul09.nasl 3411 2009-07-14 11-35-24Z jul $
#
# Microsoft Internet Explorer Buffer Overflow Vulnerability - Jul09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800910);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2433");
  script_bugtraq_id(35620);
  script_name("Microsoft Internet Explorer Buffer Overflow  Vulnerability - Jul09");
  desc = "

  Overview: This host is installed with Internet Explorer and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  The flaw is due to buffer overflow error in the the 'AddFavorite' method
  when processing a long URL in the first argument.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code, corrupt
  process memory and also crash the bowser leading to denial-of-service conditions.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version 7.x and 8.x

  Fix:
  No solution or patch is available as on 14th July, 2009. Information  regarding
  this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/downloads/ie/getitnow.mspx

  References:
  http://www.milw0rm.com/exploits/9100
  http://en.securitylab.ru/nvd/382393.php

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# Check for IE version 7.0 to 7.00.6000.16441 or 8.0 to 8.0.6001.18702
if(version_in_range(version:ieVer, test_version:"7.0",
                    test_version2:"7.00.6000.16441") ||
   version_in_range(version:ieVer, test_version:"8.0",
                    test_version2:"8.0.6001.18702")){
  security_warning(0);
}
